// Simple script to generate basic icon PNGs
// Run with: node generate-icons.js

const fs = require('fs');
const path = require('path');

// Base64 encoded simple purple circle icons (placeholder)
// These are minimal PNG files with a purple gradient circle

const icons = {
  16: `iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAA3ElEQVQ4T2NkYGBg+P///38GJMDIyMiILo4sFpQQlBJUEJQTVBNUFNQU1BXUFtQXNBA0EjQVNBc0F7QQtBS0ErQWtBG0FbQTtBd0EHQU/A8E/4GAEQj+AwEjEPyHAUYg+I8CMEPh4P+/DIxA8B8IGIHgPwwwAsF/FAA2lBEI/sMBIxD8RwGMQPAfDhiB4D8KYASCfzDwn4GREQj+wwEjEPxHAYxA8B8OGIHgPwpgBIJ/MPCfgZERCP7DASMQ/EcBjEDwHw4YgeA/CmAEgn8w8J+BEQj+wwAjEPxHAgBP+FIR7Iq9XQAAAABJRU5ErkJggg==`,
  48: `iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAA+klEQVRoQ+2YwQ3AIAwD2f9P6QJUN6gUuzbS40FEgkMc4nPO+R5+voN5wPcf8AHvBnyAtxM+wLkBH+DcgA9wbsAHODfgA5wb8AHODfgA5wZ8gHMDPsC5AR/g3IAPcG7ABzg34AOcG/ABzg34AOcGfIBzAz7AuQEf4NyAD3BuwAc4N+ADnBvwAc4N+ADnBnyAcwM+wLkBH+DcgA9wbsAHODfgA5wb8AHODfgA5wZ8gHMDPsC5AR/g3IAPcG7ABzg34AOcG/ABzg34AOcGfIBzAz7AuQEf4NyAD3BuwAc4N+ADnBvwAc4N+ADnBnyAcwM+wLkBH+DcwAsIrDBBlnl19AAAAABJRU5ErkJggg==`,
  128: `iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAABwklEQVR4nO3cMQ6AIBRF0ff/T+oOtLWxsLCwsDBRGwOJ5ty3gAs8Bk1VJUlqX3l6Acky4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgAOAA4ADgANAJ/jL4ABYfJ8kSeUP4gMYwC+rvigAAAAASUVORK5CYII=`
};

// Create icons directory if it doesn't exist
const iconsDir = path.join(__dirname, 'icons');
if (!fs.existsSync(iconsDir)) {
  fs.mkdirSync(iconsDir);
}

// Write each icon
Object.entries(icons).forEach(([size, base64]) => {
  const buffer = Buffer.from(base64, 'base64');
  const filename = path.join(iconsDir, `icon${size}.png`);
  fs.writeFileSync(filename, buffer);
  console.log(`Created ${filename}`);
});

console.log('Icons generated successfully!');
